<?php

class redimensionar{
var $image;
var $image_type;
function load($filename){
$image_info = getimagesize($filename);
$this->image_type = $image_info[2];
if($this->image_type == IMAGETYPE_JPEG){
$this->image = imagecreatefromjpeg($filename);
}
elseif($this->image_type == IMAGETYPE_GIF){
$this->image = imagecreatefromgif($filename);
}
elseif($this->image_type == IMAGETYPE_PNG){
$this->image = imagecreatefrompng($filename);
}
}
function save($filename, $image_type = IMAGETYPE_JPEG, $compression = 75, $permissions = null){
$image_type = $this->image_type;
if($image_type == IMAGETYPE_JPEG){
imagejpeg($this->image, $filename, $compression);
}
elseif($image_type == IMAGETYPE_GIF){
imagegif($this->image, $filename);
}
elseif($image_type == IMAGETYPE_PNG){
imagealphablending($this->image, false);
imagesavealpha($this->image, true);
imagepng($this->image, $filename);
}
if($permissions != null){
chmod($filename, $permissions);
}
}
function output($image_type = IMAGETYPE_JPEG){
if($image_type == IMAGETYPE_JPEG){
imagejpeg($this->image);
}
elseif($image_type == IMAGETYPE_GIF){
imagegif($this->image);
}
elseif($image_type == IMAGETYPE_PNG){
imagepng($this->image);
}
}
function getWidth(){
return imagesx($this->image);
}
function getHeight(){
return imagesy($this->image);
}
function resizeToScale($width){
$width = 1600;
$height = 1600;
if($this->getWidth()>$width || $this->getHeight()>$height){
if($this->getWidth()>$this->getHeight()){
$height = ($width * $this->getHeight()) / $this->getWidth();
$this->resize($width, $height);
}
elseif($this->getHeight()>$this->getWidth()){
$width = ($height * $this->getWidth()) / $this->getHeight();
$this->resize($width, $height);
}
else{
$width = $this->getWidth() / ($this->getWidth() / $width);
$height = $this->getHeight() / ($this->getHeight() / $height);
$this->resize($width, $height);
}
}
else{
$width = $this->getWidth();
$height = $this->getHeight();
$this->resize($width ,$height);
}
}
function resize($width, $height){
$new_image = imagecreatetruecolor($width, $height);
if(($this->image_type == IMAGETYPE_GIF) || ($this->image_type == IMAGETYPE_PNG)){
imagealphablending($new_image, false);
imagesavealpha($new_image, true);
$transparent = imagecolorallocatealpha($new_image, 255, 255, 255, 127);
imagefilledrectangle($new_image, 0, 0, $width, $height, $transparent);
}
imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
$this->image = $new_image;
}
}

?>